import { Component, HostListener, input } from '@angular/core';

import { TranslateModule } from '@ngx-translate/core';

import { IOption } from '../../../interface/theme-option.interface';
import { Button } from '../../widgets/button/button';
import { Menu } from '../../widgets/menu/menu';
import { Call } from '../widgets/call/call';
import { Cart } from '../widgets/cart/cart';
import { Compare } from '../widgets/compare/compare';
import { Logo } from '../widgets/logo/logo';
import { MyAccount } from '../widgets/my-account/my-account';
import { NavbarMenuButton } from '../widgets/navbar-menu-button/navbar-menu-button';
import { Search } from '../widgets/search/search';
import { SearchBox } from '../widgets/search-box/search-box';
import { Wishlist } from '../widgets/wishlist/wishlist';

@Component({
  selector: 'app-classic-header',
  imports: [
    TranslateModule,
    NavbarMenuButton,
    Logo,
    Search,
    Call,
    Button,
    Menu,
    SearchBox,
    Compare,
    Wishlist,
    Cart,
    MyAccount,
  ],
  templateUrl: './classic-header.html',
  styleUrl: './classic-header.scss',
})
export class ClassicHeader {
  readonly data = input<IOption | null>();
  readonly logo = input<string | null>();
  readonly sticky = input<boolean | number>(); // Default false
  readonly class = input<string>();

  public stick: boolean = false;
  public active: boolean = false;

  // @HostListener Decorator
  @HostListener('window:scroll', [])
  onWindowScroll() {
    let number =
      window.pageYOffset || document.documentElement.scrollTop || document.body.scrollTop || 0;
    if (number >= 150 && window.innerWidth > 400) {
      this.stick = true;
    } else {
      this.stick = false;
    }
  }

  toggle(val: boolean) {
    this.active = val;
  }
}
