import { CommonModule } from '@angular/common';
import { Component, inject, input } from '@angular/core';
import { ActivatedRoute, NavigationEnd, Router } from '@angular/router';

import { Store } from '@ngxs/store';
import { Observable } from 'rxjs';

import { BasicHeader } from './basic-header/basic-header';
import { ClassicHeader } from './classic-header/classic-header';
import { MinimalHeader } from './minimal-header/minimal-header';
import { StandardHeader } from './standard-header/standard-header';
import { IOption } from '../../interface/theme-option.interface';
import { ThemeOptionState } from '../../state/theme-option.state';
import { ThemeState } from '../../state/theme.state';
import { IMobileMenu } from './widgets/mobile-menu/mobile-menu';

@Component({
  selector: 'app-header',
  imports: [CommonModule, BasicHeader, ClassicHeader, MinimalHeader, StandardHeader, IMobileMenu],
  templateUrl: './header.html',
  styleUrl: './header.scss',
})
export class Header {
  public route = inject(ActivatedRoute);
  public router = inject(Router);

  themeOption$: Observable<IOption> = inject(Store).select(
    ThemeOptionState.themeOptions,
  ) as Observable<IOption>;
  activeTheme$: Observable<String> = inject(Store).select(ThemeState.activeTheme);

  readonly logo = input<string>();

  public style: string = 'basic_header';
  public sticky: boolean = true;
  public path: string;

  constructor() {
    this.route.queryParams.subscribe(params => (this.path = params['theme']));
    void this.router.events.forEach(event => {
      if (event instanceof NavigationEnd) {
        this.setHeader();
      }
    });
  }

  setHeader() {
    if (this.path) {
      if (this.path == 'rome') {
        this.style = 'standard_header';
      } else if (this.path == 'madrid') {
        this.style = 'classic_header';
      } else if (
        this.path == 'berlin' ||
        this.path == 'denver' ||
        this.path == 'moscow' ||
        this.path == 'cairo'
      ) {
        this.style = 'minimal_header';
      } else {
        this.style = 'basic_header';
      }
    } else {
      this.themeOption$.subscribe(theme => {
        this.style = theme?.header ? theme?.header.header_options : 'basic_header';
        this.sticky = theme?.header && theme?.header?.sticky_header_enable ? true : this.sticky;
      });
    }
  }
}
