import { Component, HostListener, Input, input } from '@angular/core';

import { TranslateModule } from '@ngx-translate/core';

import { IOption } from '../../../../shared/interface/theme-option.interface';
import { Button } from '../../widgets/button/button';
import { Menu } from '../../widgets/menu/menu';
import { Cart } from '../widgets/cart/cart';
import { Logo } from '../widgets/logo/logo';
import { MyAccount } from '../widgets/my-account/my-account';
import { NavbarMenuButton } from '../widgets/navbar-menu-button/navbar-menu-button';
import { Search } from '../widgets/search/search';
import { Topbar } from '../widgets/topbar/topbar';
import { Wishlist } from '../widgets/wishlist/wishlist';

@Component({
  selector: 'app-minimal-header',
  imports: [
    TranslateModule,
    Topbar,
    NavbarMenuButton,
    Logo,
    Button,
    Menu,
    Search,
    Wishlist,
    Cart,
    MyAccount,
  ],
  templateUrl: './minimal-header.html',
  styleUrl: './minimal-header.scss',
})
export class MinimalHeader {
  @Input() data: IOption | null;
  readonly logo = input<string | null>();
  readonly sticky = input<boolean | number>(); // Default false
  readonly class = input<string>();

  public stick: boolean = false;
  public active: boolean = false;

  // @HostListener Decorator
  @HostListener('window:scroll', [])
  onWindowScroll() {
    let number =
      window.pageYOffset || document.documentElement.scrollTop || document.body.scrollTop || 0;
    if (number >= 150 && window.innerWidth > 400) {
      this.stick = true;
    } else {
      this.stick = false;
    }
  }

  toggle(val: boolean) {
    this.active = val;
  }
}
