import { AsyncPipe, CommonModule } from '@angular/common';
import { Component, inject, viewChild } from '@angular/core';

import { TranslateModule } from '@ngx-translate/core';
import { Store } from '@ngxs/store';
import { Observable } from 'rxjs';

import { IValues } from '../../../../interface/setting.interface';
import { LocationService } from '../../../../services/location.service';
import { SettingState } from '../../../../state/setting.state';
import { ZoneState } from '../../../../state/zone.state';
import { Button } from '../../../widgets/button/button';
import { LocationModal } from '../../../widgets/modal/location-modal/location-modal';

@Component({
  selector: 'app-location',
  imports: [CommonModule, TranslateModule, Button, LocationModal, AsyncPipe, Button],
  templateUrl: './location.html',
  styleUrl: './location.scss',
})
export class Location {
  public locationService = inject(LocationService);

  readonly LocationModal = viewChild<LocationModal>('locationModal');

  location$: Observable<string> = inject(Store).select(ZoneState.location) as Observable<string>;
  selectedZone$: Observable<boolean> = inject(Store).select(
    ZoneState.isZoneSelected,
  ) as Observable<boolean>;
  setting$: Observable<IValues | null> = inject(Store).select(
    SettingState.setting,
  ) as Observable<IValues | null>;

  ngOnInit() {
    this.setting$.subscribe(
      value => (this.locationService.is_zone = Boolean(value?.activation?.zone_enable)),
    );
    this.selectedZone$.subscribe(isZoneSelected => {
      this.locationService.is_zone_selected = isZoneSelected;
      this.locationService.zone_toggle = !isZoneSelected;
    });
  }

  getCurrentLocation(): void {
    this.locationService.getCurrentLocation();
  }
}
