import { Component, inject, Input, input } from '@angular/core';
import { RouterModule } from '@angular/router';

import { Store } from '@ngxs/store';
import { Observable } from 'rxjs';

import { ThemeOptionState } from '../../../../../shared/state/theme-option.state';
import { IOption } from '../../../../interface/theme-option.interface';

@Component({
  selector: 'app-logo',
  imports: [RouterModule],
  templateUrl: './logo.html',
  styleUrl: './logo.scss',
})
export class Logo {
  readonly textClass = input<string>('f-w-600');
  readonly data = input<IOption | null>();
  @Input() logo: string | null | undefined;

  themeOption$: Observable<IOption> = inject(Store).select(
    ThemeOptionState.themeOptions,
  ) as Observable<IOption>;
}
