import { Component, inject } from '@angular/core';
import { RouterModule } from '@angular/router';

import { Store } from '@ngxs/store';

import { ToggleSidebarCartAction } from '../../../../action/cart.action';

@Component({
  selector: 'app-mobile-menu',
  imports: [RouterModule],
  templateUrl: './mobile-menu.html',
  styleUrl: './mobile-menu.scss',
})
export class IMobileMenu {
  private store = inject(Store);

  public active: string = '/';

  cartToggle(value: boolean) {
    this.store.dispatch(new ToggleSidebarCartAction(value));
  }

  activeMenu(menu: string) {
    this.active = menu;
  }
}
