import { CommonModule } from '@angular/common';
import { Component, inject, input, viewChild } from '@angular/core';
import { RouterModule } from '@angular/router';

import { TranslateModule } from '@ngx-translate/core';
import { Store } from '@ngxs/store';
import { Observable } from 'rxjs';

import { LogoutAction } from '../../../../action/auth.action';
import { IAccountUser } from '../../../../interface/account.interface';
import { AccountState } from '../../../../state/account.state';
import { AuthState } from '../../../../state/auth.state';
import { ConfirmationModal } from '../../../widgets/modal/confirmation-modal/confirmation-modal';

@Component({
  selector: 'app-my-account',
  imports: [CommonModule, TranslateModule, RouterModule, ConfirmationModal],
  templateUrl: './my-account.html',
  styleUrl: './my-account.scss',
})
export class MyAccount {
  private store = inject(Store);

  readonly style = input<string>('basic');

  isAuthenticated$: Observable<Boolean> = inject(Store).select(AuthState.isAuthenticated);
  user$: Observable<IAccountUser> = inject(Store).select(
    AccountState.user,
  ) as Observable<IAccountUser>;

  readonly ConfirmationModal = viewChild<ConfirmationModal>('confirmationModal');

  logout() {
    this.store.dispatch(new LogoutAction());
  }
}
