import { Component, SimpleChanges, input, output } from '@angular/core';

import { Button } from '../../../widgets/button/button';

@Component({
  selector: 'app-navbar-menu-button',
  imports: [Button],
  templateUrl: './navbar-menu-button.html',
  styleUrl: './navbar-menu-button.scss',
})
export class NavbarMenuButton {
  readonly activeMenu = output<boolean>();
  readonly show = input<boolean>();

  public active: boolean = false;

  ngOnChanges(changes: SimpleChanges) {
    this.active = changes['show']?.currentValue;
  }

  toggleMenu() {
    this.active = !this.active;
    this.activeMenu.emit(this.active);
  }
}
