import { CommonModule } from '@angular/common';
import { Component, ElementRef, inject, Input, input, viewChild } from '@angular/core';
import { Router, RouterModule } from '@angular/router';

import { TranslateModule } from '@ngx-translate/core';
import { Store } from '@ngxs/store';
import { Observable } from 'rxjs';

import { ICategory } from '../../../../../interface/category.interface';
import { IProduct } from '../../../../../interface/product.interface';
import { HighlighterPipe } from '../../../../../pipe/highlighter.pipe';
import { CategoryService } from '../../../../../services/category.service';
import { ProductService } from '../../../../../services/product.service';
import { ProductState } from '../../../../../state/product.state';

@Component({
  selector: 'app-search-dropdown',
  imports: [CommonModule, TranslateModule, RouterModule, HighlighterPipe],
  templateUrl: './search-dropdown.html',
  styleUrl: './search-dropdown.scss',
})
export class SearchDropdown {
  public categoryService = inject(CategoryService);
  public productService = inject(ProductService);
  public router = inject(Router);

  readonly term = input<any>();
  readonly isOpenResult = input<boolean>();
  readonly selectedResultIndex = input<any>();
  @Input() categories: ICategory[];
  readonly products = input<IProduct[]>();
  readonly selectedCategory = input<String>();

  readonly resultsContainer = viewChild<ElementRef>('resultsContainer');

  productBySearch$: Observable<IProduct[]> = inject(Store).select(ProductState.productBySearch);

  public skeleton = Array.from({ length: 3 }, (_, index) => index);
}
