import { CommonModule } from '@angular/common';
import { Component, inject, Input } from '@angular/core';
import { FormsModule } from '@angular/forms';

import { TranslateModule } from '@ngx-translate/core';
import { Store } from '@ngxs/store';

import { IOption } from '../../../../interface/theme-option.interface';
import { Currency } from '../currency/currency';
import { Language } from '../language/language';
import { Location } from '../location/location';
import { Notice } from '../notice/notice';

@Component({
  selector: 'app-topbar',
  imports: [TranslateModule, Notice, Language, CommonModule, FormsModule, Currency, Location],
  templateUrl: './topbar.html',
  styleUrl: './topbar.scss',
})
export class Topbar {
  private store = inject(Store);

  @Input() data: IOption | null;

  public is_zone: boolean;
  public is_zone_selected: number[];
  public zone_toggle: boolean = false;

  constructor() {
    this.is_zone = this.store.selectSnapshot(
      state => state?.setting?.setting?.activation?.zone_enable,
    );
    this.is_zone_selected =
      this.store.selectSnapshot(state => state.zone.selectedZone).length ||
      this.store.selectSnapshot(state => state.zone.location);
  }
}
