import { CommonModule } from '@angular/common';
import { Component, inject, Input, input } from '@angular/core';

import { Store } from '@ngxs/store';
import { Observable } from 'rxjs';

import { LoaderState } from '../../../state/loader.state';

@Component({
  selector: 'app-button',
  imports: [CommonModule],
  templateUrl: './button.html',
  styleUrl: './button.scss',
})
export class Button {
  readonly class = input<string>('btn btn-animation w-100 justify-content-center');
  @Input() iconClass: string | null;
  readonly id = input<string>();
  readonly label = input<string>();
  readonly type = input<string>('submit');
  readonly spinner = input<boolean>(true);
  readonly disabled = input<boolean>(false);

  public buttonId: string | null;

  spinnerStatus$: Observable<boolean> = inject(Store).select(
    LoaderState.buttonSpinner,
  ) as Observable<boolean>;

  constructor() {
    this.spinnerStatus$.subscribe(res => {
      if (res == false) {
        this.buttonId = null;
      }
    });
  }

  public onClick(id: string) {
    this.buttonId = id;
  }
}
