import { CommonModule } from '@angular/common';
import { Component, inject, Input, input } from '@angular/core';
import { RouterModule } from '@angular/router';

import { Store } from '@ngxs/store';
import { Observable } from 'rxjs';

import { environment } from '../../../../../environments/environment';
import { IProduct, IProductModel } from '../../../../shared/interface/product.interface';
import { ProductState } from '../../../../shared/state/product.state';

@Component({
  selector: 'app-image-link',
  imports: [CommonModule, RouterModule],
  templateUrl: './image-link.html',
  styleUrl: './image-link.scss',
})
export class ImageLink {
  product$: Observable<IProductModel> = inject(Store).select(ProductState.product);

  @Input() image: any;
  readonly link = input<string>();
  readonly bgImage = input<boolean>();
  readonly class = input<string>();

  public storageURL = environment.storageURL;

  getProductSlug(id: number, products: IProduct[]) {
    let product = products.find(product => product.id === id);
    return product ? product.slug : null;
  }
}
