import { Component, inject, Input } from '@angular/core';
import { Router } from '@angular/router';

import { TranslateModule } from '@ngx-translate/core';

import { IMenu } from '../../../../interface/menu.interface';

@Component({
  selector: 'app-link-box',
  imports: [TranslateModule],
  templateUrl: './link-box.html',
  styleUrl: './link-box.scss',
})
export class LinkBox {
  private router = inject(Router);

  @Input() menu: IMenu;

  redirect(path: string) {
    void this.router.navigateByUrl(path);
  }
}
