import { Component, TemplateRef, Input, viewChild, inject } from '@angular/core';
import { RouterModule } from '@angular/router';

import { ModalDismissReasons, NgbModal } from '@ng-bootstrap/ng-bootstrap';
import { TranslateModule } from '@ngx-translate/core';

import { IProduct } from '../../../../../shared/interface/product.interface';
import { CurrencySymbolPipe } from '../../../../pipe/currency-symbol.pipe';
import { Button } from '../../button/button';
import { NoData } from '../../no-data/no-data';

@Component({
  selector: 'app-deals-modal',
  imports: [TranslateModule, RouterModule, CurrencySymbolPipe, Button, NoData],
  templateUrl: './deals-modal.html',
  styleUrl: './deals-modal.scss',
})
export class DealsModal {
  private modalService = inject(NgbModal);

  readonly dealsModal = viewChild<TemplateRef<unknown>>('dealsModal');

  @Input() products: IProduct[];

  public closeResult: string;
  public modalOpen: boolean = false;

  async openModal() {
    this.modalOpen = true;
    this.modalService
      .open(this.dealsModal(), {
        ariaLabelledBy: 'Deal-Modal',
        centered: true,
        windowClass: 'theme-modal deal-modal',
      })
      .result.then(
        result => {
          `Result ${result}`;
        },
        reason => {
          this.closeResult = `Dismissed ${this.getDismissReason(reason)}`;
        },
      );
  }

  private getDismissReason(reason: any): string {
    if (reason === ModalDismissReasons.ESC) {
      return 'by pressing ESC';
    } else if (reason === ModalDismissReasons.BACKDROP_CLICK) {
      return 'by clicking on a backdrop';
    } else {
      return `with: ${reason}`;
    }
  }

  closeModal() {
    this.modalService.dismissAll();
  }
}
