import { Component, inject, TemplateRef, viewChild } from '@angular/core';

import { ModalDismissReasons, NgbModal } from '@ng-bootstrap/ng-bootstrap';
import { TranslateModule } from '@ngx-translate/core';
import { Store } from '@ngxs/store';
import { Observable } from 'rxjs';

import { IOption } from '../../../../../shared/interface/theme-option.interface';
import { ThemeOptionState } from '../../../../../shared/state/theme-option.state';
import { Button } from '../../button/button';

@Component({
  selector: 'app-delivery-return-modal',
  imports: [TranslateModule, Button],
  templateUrl: './delivery-return-modal.html',
  styleUrl: './delivery-return-modal.scss',
})
export class DeliveryReturnModal {
  private modalService = inject(NgbModal);

  readonly DeliveryReturnModal = viewChild<TemplateRef<string>>('deliveryReturnModal');

  themeOption$: Observable<IOption> = inject(Store).select(
    ThemeOptionState.themeOptions,
  ) as Observable<IOption>;

  public closeResult: string;
  public modalOpen: boolean = false;
  public policy: string;

  async openModal(value: string) {
    this.policy = value;
    this.modalOpen = true;
    this.modalService
      .open(this.DeliveryReturnModal(), {
        ariaLabelledBy: 'profile-Modal',
        centered: true,
        windowClass: 'theme-modal modal-lg',
      })
      .result.then(
        result => {
          `Result ${result}`;
        },
        reason => {
          this.closeResult = `Dismissed ${this.getDismissReason(reason)}`;
        },
      );
  }

  private getDismissReason(reason: ModalDismissReasons): string {
    if (reason === ModalDismissReasons.ESC) {
      return 'by pressing ESC';
    } else if (reason === ModalDismissReasons.BACKDROP_CLICK) {
      return 'by clicking on a backdrop';
    } else {
      return `with: ${reason}`;
    }
  }
}
