import { Component, HostListener, inject, TemplateRef, viewChild } from '@angular/core';

import { ModalDismissReasons, NgbModal } from '@ng-bootstrap/ng-bootstrap';
import { Store } from '@ngxs/store';
import { Observable } from 'rxjs';

import { environment } from '../../../../../../environments/environment';
import { UpdateSessionAction } from '../../../../../shared/action/theme-option.action';
import { ThemeOptionState } from '../../../../../shared/state/theme-option.state';
import { IOption } from '../../../../interface/theme-option.interface';
import { Button } from '../../button/button';

@Component({
  selector: 'app-exit-modal',
  imports: [Button],
  templateUrl: './exit-modal.html',
  styleUrl: './exit-modal.scss',
})
export class ExitModal {
  private modalService = inject(NgbModal);
  private store = inject(Store);

  readonly ExitModal = viewChild<TemplateRef<string>>('exitModal');

  exit$: Observable<boolean> = inject(Store).select(ThemeOptionState.exit) as Observable<boolean>;
  themeOption$: Observable<IOption> = inject(Store).select(
    ThemeOptionState.themeOptions,
  ) as Observable<IOption>;

  public closeResult: string;
  public modalOpen: boolean = true;
  public isTabInFocus = true;
  public exit: boolean;
  public themeOption: IOption;
  public storageURL = environment.storageURL;

  constructor() {
    this.exit$.subscribe(res => (this.exit = res));
    this.themeOption$.subscribe(res => (this.themeOption = res));
  }

  @HostListener('window:mouseout', ['$event'])
  onMouseOut(event: MouseEvent) {
    if (event.clientY <= 0) {
      if (this.exit === true) {
        void this.openModal();
        this.store.dispatch(new UpdateSessionAction('exit', false));
      }
    }
  }

  async openModal() {
    localStorage.setItem('exit', 'true');
    this.modalOpen = true;
    this.modalService
      .open(this.ExitModal(), {
        ariaLabelledBy: 'profile-Modal',
        centered: true,
        windowClass: 'theme-modal modal-lg exit-modal',
      })
      .result.then(
        result => {
          `Result ${result}`;
        },
        reason => {
          this.closeResult = `Dismissed ${this.getDismissReason(reason)}`;
        },
      );
  }

  private getDismissReason(reason: ModalDismissReasons): string {
    if (reason === ModalDismissReasons.ESC) {
      return 'by pressing ESC';
    } else if (reason === ModalDismissReasons.BACKDROP_CLICK) {
      return 'by clicking on a backdrop';
    } else {
      return `with: ${reason}`;
    }
  }
}
