import { Component, inject, TemplateRef, viewChild } from '@angular/core';

import { ModalDismissReasons, NgbModal } from '@ng-bootstrap/ng-bootstrap';
import { TranslateModule } from '@ngx-translate/core';

import { IAttachment } from '../../../../../shared/interface/attachment.interface';
import { Button } from '../../button/button';

@Component({
  selector: 'app-size-chart-modal',
  imports: [TranslateModule, Button],
  templateUrl: './size-chart-modal.html',
  styleUrl: './size-chart-modal.scss',
})
export class SizeChartModal {
  private modalService = inject(NgbModal);

  readonly SizeChartModal = viewChild<TemplateRef<string>>('sizeChartModal');

  public closeResult: string;
  public modalOpen: boolean = false;
  public image: IAttachment;

  async openModal(image: IAttachment) {
    this.image = image;
    this.modalOpen = true;
    this.modalService
      .open(this.SizeChartModal(), {
        ariaLabelledBy: 'profile-Modal',
        centered: true,
        windowClass: 'theme-modal modal-lg',
      })
      .result.then(
        result => {
          `Result ${result}`;
        },
        reason => {
          this.closeResult = `Dismissed ${this.getDismissReason(reason)}`;
        },
      );
  }

  private getDismissReason(reason: ModalDismissReasons): string {
    if (reason === ModalDismissReasons.ESC) {
      return 'by pressing ESC';
    } else if (reason === ModalDismissReasons.BACKDROP_CLICK) {
      return 'by clicking on a backdrop';
    } else {
      return `with: ${reason}`;
    }
  }
}
