import { Component, inject, Input, input } from '@angular/core';
import { RouterModule } from '@angular/router';

import { NgbModule, NgbRatingConfig } from '@ng-bootstrap/ng-bootstrap';
import { TranslateModule } from '@ngx-translate/core';
import { Store } from '@ngxs/store';

import { DeleteWishlistAction } from '../../../../action/wishlist.action';
import { IProduct } from '../../../../interface/product.interface';
import { CurrencySymbolPipe } from '../../../../pipe/currency-symbol.pipe';
import { Button } from '../../button/button';
import { ProductCartButton } from '../widgets/product-cart-button/product-cart-button';
import { ProductHoverAction } from '../widgets/product-hover-action/product-hover-action';

@Component({
  selector: 'app-classic-product-box',
  imports: [
    CurrencySymbolPipe,
    RouterModule,
    NgbModule,
    TranslateModule,
    ProductHoverAction,
    Button,
    ProductCartButton,
  ],
  templateUrl: './classic-product-box.html',
  styleUrl: './classic-product-box.scss',
})
export class ClassicProductBox {
  private store = inject(Store);
  public config = inject(NgbRatingConfig);

  @Input() product: IProduct;
  readonly class = input<string>();
  readonly close = input<boolean>();

  constructor() {
    this.config.max = 5;
    this.config.readonly = true;
  }

  removeWishlist(id: number) {
    this.store.dispatch(new DeleteWishlistAction(id));
  }
}
