import { Component, inject, Input, input } from '@angular/core';
import { RouterModule } from '@angular/router';

import { NgbModule } from '@ng-bootstrap/ng-bootstrap';
import { TranslateModule } from '@ngx-translate/core';
import { Store } from '@ngxs/store';
import { Observable } from 'rxjs';

import { AddToWishlistAction, DeleteWishlistAction } from '../../../../action/wishlist.action';
import { IProduct } from '../../../../interface/product.interface';
import { CurrencySymbolPipe } from '../../../../pipe/currency-symbol.pipe';
import { ThemeOptionService } from '../../../../services/theme-option.service';
import { WishlistState } from '../../../../state/wishlist.state';
import { Button } from '../../button/button';
import { ProductCartButton } from '../widgets/product-cart-button/product-cart-button';

@Component({
  selector: 'app-digital-product-box',
  imports: [
    TranslateModule,
    NgbModule,
    RouterModule,
    CurrencySymbolPipe,
    Button,
    ProductCartButton,
  ],
  templateUrl: './digital-product-box.html',
  styleUrl: './digital-product-box.scss',
})
export class DigitalProductBox {
  private store = inject(Store);
  public themeOptionService = inject(ThemeOptionService);

  readonly class = input<string>();
  readonly close = input<boolean>();
  @Input() product: IProduct;

  wishlistIds$: Observable<number[]> = inject(Store).select(WishlistState.wishlistIds);

  public wishlistIds: number[];

  addToWishlist(product: IProduct) {
    product['is_wishlist'] = !product['is_wishlist'];
    let action = product['is_wishlist']
      ? new AddToWishlistAction({ product_id: product.id })
      : new DeleteWishlistAction(product.id);
    if (action) {
      this.store.dispatch(action);
    }
  }

  removeWishlist(id: number) {
    this.store.dispatch(new DeleteWishlistAction(id));
  }
}
