import { Component, inject, Input, input } from '@angular/core';
import { RouterModule } from '@angular/router';

import { NgbModule, NgbRatingConfig } from '@ng-bootstrap/ng-bootstrap';
import { Store } from '@ngxs/store';
import { Observable } from 'rxjs';

import { AddToWishlistAction, DeleteWishlistAction } from '../../../../action/wishlist.action';
import { ICart } from '../../../../interface/cart.interface';
import { IProduct } from '../../../../interface/product.interface';
import { CurrencySymbolPipe } from '../../../../pipe/currency-symbol.pipe';
import { TitleCasePipe } from '../../../../pipe/title-case.pipe';
import { WishlistState } from '../../../../state/wishlist.state';
import { Button } from '../../button/button';
import { ProductCartButton } from '../widgets/product-cart-button/product-cart-button';
import { ProductHoverAction } from '../widgets/product-hover-action/product-hover-action';

@Component({
  selector: 'app-premium-product-box',
  imports: [
    RouterModule,
    NgbModule,
    CurrencySymbolPipe,
    TitleCasePipe,
    ProductHoverAction,
    Button,
    ProductCartButton,
  ],
  templateUrl: './premium-product-box.html',
  styleUrl: './premium-product-box.scss',
})
export class PremiumProductBox {
  private store = inject(Store);
  public config = inject(NgbRatingConfig);

  @Input() product: IProduct;
  readonly class = input<string>();
  readonly close = input<boolean>();

  wishlistIds$: Observable<number[]> = inject(Store).select(WishlistState.wishlistIds);

  public cartItem: ICart | null;
  public currentDate: number | null;
  public saleStartDate: number | null;

  public wishlistIds: number[];

  constructor() {
    this.config.max = 5;
    this.config.readonly = true;
  }

  removeWishlist(id: number) {
    this.store.dispatch(new DeleteWishlistAction(id));
  }

  addToWishlist(product: IProduct) {
    product['is_wishlist'] = !product['is_wishlist'];
    let action = product['is_wishlist']
      ? new AddToWishlistAction({ product_id: product.id })
      : new DeleteWishlistAction(product.id);
    if (action) {
      this.store.dispatch(action);
    }
  }
}
