import { Component, inject, input } from '@angular/core';

import { Store } from '@ngxs/store';
import { Observable } from 'rxjs';

import { BasicProductBox } from './basic-product-box/basic-product-box';
import { ClassicProductBox } from './classic-product-box/classic-product-box';
import { DigitalProductBox } from './digital-product-box/digital-product-box';
import { PremiumProductBox } from './premium-product-box/premium-product-box';
import { ProductBoxVertical } from './product-box-vertical/product-box-vertical';
import { StandardProductBox } from './standard-product-box/standard-product-box';
import { IProduct } from '../../../../shared/interface/product.interface';
import { IOption } from '../../../interface/theme-option.interface';
import { ThemeOptionService } from '../../../services/theme-option.service';
import { ThemeOptionState } from '../../../state/theme-option.state';

@Component({
  selector: 'app-product-box',
  imports: [
    BasicProductBox,
    PremiumProductBox,
    ClassicProductBox,
    StandardProductBox,
    DigitalProductBox,
    ProductBoxVertical,
  ],
  templateUrl: './product-box.html',
  styleUrl: './product-box.scss',
})
export class ProductBox {
  public themeOptionService = inject(ThemeOptionService);

  readonly product = input<IProduct>();
  readonly style = input<string>('horizontal');
  readonly class = input<string>();
  readonly close = input<boolean>(false);

  public variant: string;
  public theme: string;

  themeOption$: Observable<IOption> = inject(Store).select(
    ThemeOptionState.themeOptions,
  ) as Observable<IOption>;
}
