import { CommonModule } from '@angular/common';
import { Component, inject, Input, input } from '@angular/core';
import { RouterModule } from '@angular/router';

import { NgbRatingConfig } from '@ng-bootstrap/ng-bootstrap';
import { TranslateModule } from '@ngx-translate/core';
import { Store } from '@ngxs/store';

import { DeleteWishlistAction } from '../../../../action/wishlist.action';
import { IProduct } from '../../../../interface/product.interface';
import { CurrencySymbolPipe } from '../../../../pipe/currency-symbol.pipe';
import { Button } from '../../button/button';
import { ProductCartButton } from '../widgets/product-cart-button/product-cart-button';
import { ProductHoverAction } from '../widgets/product-hover-action/product-hover-action';

@Component({
  selector: 'app-standard-product-box',
  imports: [
    CommonModule,
    RouterModule,
    TranslateModule,
    CurrencySymbolPipe,
    Button,
    ProductHoverAction,
    ProductCartButton,
  ],
  templateUrl: './standard-product-box.html',
  styleUrl: './standard-product-box.scss',
})
export class StandardProductBox {
  private store = inject(Store);
  public config = inject(NgbRatingConfig);

  @Input() product: IProduct;
  readonly class = input<string>();
  readonly close = input<boolean>();

  constructor() {
    this.config.max = 5;
    this.config.readonly = true;
  }

  removeWishlist(id: number) {
    this.store.dispatch(new DeleteWishlistAction(id));
  }
}
