import { Component, inject, input, viewChild } from '@angular/core';

import { Store } from '@ngxs/store';
import { Observable } from 'rxjs';

import { AddToCompareAction } from '../../../../../action/compare.action';
import { AddToWishlistAction, DeleteWishlistAction } from '../../../../../action/wishlist.action';
import { IProduct } from '../../../../../interface/product.interface';
import { WishlistState } from '../../../../../state/wishlist.state';
import { ProductDetailModal } from '../../../modal/product-detail-modal/product-detail-modal';
import { VariationModal } from '../../../modal/variation-modal/variation-modal';

@Component({
  selector: 'app-product-hover-action',
  imports: [ProductDetailModal, VariationModal],
  templateUrl: './product-hover-action.html',
  styleUrl: './product-hover-action.scss',
})
export class ProductHoverAction {
  private store = inject(Store);

  readonly product = input<IProduct>();
  readonly hideAction = input<string[]>();

  readonly productDetailModal = viewChild<ProductDetailModal>('productDetailModal');
  readonly VariationModal = viewChild<VariationModal>('variationModal');

  wishlistIds$: Observable<number[]> = inject(Store).select(WishlistState.wishlistIds);

  addToWishlist(product: IProduct) {
    product['is_wishlist'] = !product['is_wishlist'];
    let action = product['is_wishlist']
      ? new AddToWishlistAction({ product_id: product.id })
      : new DeleteWishlistAction(product.id);
    if (action) {
      this.store.dispatch(action);
    }
  }

  addToCompare(id: number) {
    this.store.dispatch(new AddToCompareAction({ product_id: id }));
  }
}
