import { CommonModule } from '@angular/common';
import { Component, inject } from '@angular/core';
import { RouterModule } from '@angular/router';

import { TranslateModule } from '@ngx-translate/core';
import { Store } from '@ngxs/store';
import { Observable } from 'rxjs';

import { ICart } from '../../../interface/cart.interface';
import { CurrencySymbolPipe } from '../../../pipe/currency-symbol.pipe';
import { CartState } from '../../../state/cart.state';
import { Button } from '../button/button';

@Component({
  selector: 'app-sticky-cart',
  imports: [CommonModule, TranslateModule, RouterModule, CurrencySymbolPipe, Button],
  templateUrl: './sticky-cart.html',
  styleUrl: './sticky-cart.scss',
})
export class StickyCart {
  cartItem$: Observable<ICart[]> = inject(Store).select(CartState.cartItems);
  cartTotal$: Observable<number> = inject(Store).select(CartState.cartTotal);
  stickyCart$: Observable<boolean> = inject(Store).select(CartState.stickyCart);

  public isOpen: boolean;

  constructor() {
    this.stickyCart$.subscribe(value => (this.isOpen = value));
  }

  openCart(isOpen: boolean) {
    this.isOpen = isOpen;
  }
}
