import { CommonModule } from '@angular/common';
import { Component, inject } from '@angular/core';
import { FormsModule } from '@angular/forms';

import { TranslateModule } from '@ngx-translate/core';
import { Store } from '@ngxs/store';
import { Observable } from 'rxjs';

import { ThemeOptionService } from '../../../../shared/services/theme-option.service';
import { ThemeOptionState } from '../../../../shared/state/theme-option.state';
import { ClickOutsideDirective } from '../../../directive/out-side-directive';
import { IOption } from '../../../interface/theme-option.interface';
import { Button } from '../button/button';

@Component({
  selector: 'app-theme-customizer',
  imports: [CommonModule, TranslateModule, FormsModule, Button, ClickOutsideDirective],
  templateUrl: './theme-customizer.html',
  styleUrl: './theme-customizer.scss',
})
export class ThemeCustomizer {
  public themeOptionService = inject(ThemeOptionService);

  themeOption$: Observable<IOption> = inject(Store).select(
    ThemeOptionState.themeOptions,
  ) as Observable<IOption>;

  public open: boolean = false;
  public show: boolean = false;
  public mode: string;
  public value: string;
  public theme_color: string;
  public secondary_color: string;
  public theme: string;

  ngOnInit() {
    this.themeOption$.subscribe(option => {
      this.mode = option?.general ? option?.general?.mode : 'light';
      this.value = option?.general ? option?.general?.language_direction : 'ltr';
    });
  }

  toggle() {
    this.open = !this.open;
  }

  layout(value: string) {
    this.value = value;
    if (value === 'rtl') {
      document.body.classList.add('rtl');
    } else {
      document.body.classList.remove('rtl');
    }
  }

  layoutMode(value: string) {
    this.mode = value;
    if (this.mode === 'dark') {
      document.getElementsByTagName('html')[0].classList.add('dark');
    } else {
      document.getElementsByTagName('html')[0].classList.remove('dark');
    }
  }

  customizeThemeColor(event: Event, val: string) {
    const input = event.target as HTMLInputElement;
    document.documentElement.style.setProperty(val, input.value);
  }

  closeDropdown() {
    this.open = false;
  }
}
