import { IAttachment } from './attachment.interface';
import { IPaginateModel } from './core.interface';
import { ICountry } from './country.interface';
import { IStates } from './state.interface';

export interface IPublicationModel extends IPaginateModel {
  data: IPublication[];
}

export interface IPublication {
  id: number;
  publisher_name: string;
  description: string;
  slug: string;
  publisher_logo_id: number;
  publisher_logo: IAttachment;
  publisher_cover_image_id: number;
  publisher_cover_image: IAttachment;
  country_id: number;
  state_id: number;
  city: string;
  facebook?: string;
  twitter?: string;
  instagram?: string;
  youtube?: string;
  pinterest?: string;
  created_by_id: number;
  status: boolean;
  country: ICountry;
  state: IStates;
  created_at?: string;
  updated_at?: string;
  deleted_at?: string;
}
