import { inject } from '@angular/core';
import { ResolveFn } from '@angular/router';

import { Store } from '@ngxs/store';
import { Observable } from 'rxjs';

import { GetHomePageAction } from '../action/theme.action';

export const ThemeResolver: ResolveFn<Observable<unknown>> = (route, _state) => {
  const store = inject(Store);
  const slug = route.paramMap.get('slug') || 'paris';

  return store.dispatch(new GetHomePageAction(slug));
};
