import { HttpClient } from '@angular/common/http';
import { inject, Injectable } from '@angular/core';

import { Observable } from 'rxjs';

import { environment } from '../../../environments/environment';
import { IAccountUser, IAccountUserUpdatePassword } from '../interface/account.interface';
import { IUserAddress } from '../interface/user.interface';

@Injectable({
  providedIn: 'root',
})
export class AccountService {
  private http = inject(HttpClient);

  getUserDetails(): Observable<any> {
    return this.http.get<IAccountUser>(`${environment.URL}/self`);
  }

  updateProfile(payload: IAccountUser): Observable<IAccountUser> {
    return this.http.post<IAccountUser>(`${environment.URL}/updateProfile`, payload);
  }

  updatePassword(payload: IAccountUserUpdatePassword): Observable<IAccountUserUpdatePassword> {
    return this.http.put<IAccountUserUpdatePassword>(`${environment.URL}/updatePassword`, payload);
  }

  createAddress(payload: IUserAddress): Observable<IUserAddress> {
    return this.http.post<IUserAddress>(`${environment.URL}/address`, payload);
  }

  updateAddress(payload: IUserAddress, id: number): Observable<IUserAddress> {
    return this.http.put<IUserAddress>(`${environment.URL}/address/${id}`, payload);
  }

  deleteAddress(id: number): Observable<number> {
    return this.http.delete<number>(`${environment.URL}/address/${id}`);
  }
}
