import { HttpClient } from '@angular/common/http';
import { inject, Injectable } from '@angular/core';

import { Observable } from 'rxjs';

import { environment } from '../../../environments/environment';
import { IAttributeModel, IAttributeValueModel } from '../interface/attribute.interface';
import { Params } from '../interface/core.interface';

@Injectable({
  providedIn: 'root',
})
export class AttributeService {
  public skeletonLoader: boolean = false;
  public offCanvasMenu: boolean = false;

  private http = inject(HttpClient);

  getAttributes(payload?: Params): Observable<IAttributeModel> {
    return this.http.get<IAttributeModel>(`${environment.URL}/attribute`, { params: payload });
  }

  getAttributeValues(payload?: Params): Observable<IAttributeValueModel> {
    return this.http.get<IAttributeValueModel>(`${environment.URL}/attribute-value`, {
      params: payload,
    });
  }
}
