import { HttpClient } from '@angular/common/http';
import { inject, Injectable } from '@angular/core';

import { Observable } from 'rxjs';

import { environment } from '../../../environments/environment';
import {
  IAuthNumberLoginState,
  IAuthStateModal,
  IAuthUserForgotModel,
  IAuthUserStateModel,
  IAuthVerifyNumberOTPState,
  IRegisterModal,
  IUpdatePasswordModel,
  IVerifyEmailOtpModel,
} from '../interface/auth.interface';

@Injectable({
  providedIn: 'root',
})
export class AuthService {
  public redirectUrl: string | undefined;
  public otpType: string;

  private http = inject(HttpClient);

  register(payload: IRegisterModal): Observable<any> {
    return this.http.post(`${environment.URL}/register`, payload);
  }

  login(payload: IAuthUserStateModel): Observable<any> {
    return this.http.post(`${environment.URL}/login`, payload);
  }

  loginWithNumber(payload: IAuthNumberLoginState): Observable<IAuthStateModal> {
    return this.http.post<IAuthStateModal>(`${environment.URL}/login/number`, payload);
  }

  forgotPassword(payload: IAuthUserForgotModel): Observable<any> {
    return this.http.post(`${environment.URL}/forgot-password`, payload);
  }

  verifyEmailOtp(payload: IVerifyEmailOtpModel): Observable<any> {
    return this.http.post(`${environment.URL}/verify-token`, payload);
  }

  verifyNumberOtp(payload: IAuthVerifyNumberOTPState): Observable<IAuthStateModal> {
    return this.http.post<IAuthStateModal>(`${environment.URL}/verify-otp`, payload);
  }

  updatePassword(payload: IUpdatePasswordModel): Observable<any> {
    return this.http.post(`${environment.URL}/update-password`, payload);
  }

  logout(): Observable<any> {
    return this.http.post(`${environment.URL}/logout`, {});
  }
}
