import { HttpClient } from '@angular/common/http';
import { inject, Injectable } from '@angular/core';

import { Observable } from 'rxjs';

import { environment } from '../../../environments/environment';
import { IAuthor } from '../interface/author.interface';

@Injectable({
  providedIn: 'root',
})
export class AuthorService {
  private http = inject(HttpClient);

  getAuthorBySlug(slug: string): Observable<IAuthor> {
    return this.http.get<IAuthor>(`${environment.URL}/author/slug/${slug}`);
  }
}
