import { HttpClient } from '@angular/common/http';
import { inject, Injectable } from '@angular/core';

import { Observable } from 'rxjs';

import { environment } from '../../../environments/environment';
import { IBlog, IBlogModel } from '../interface/blog.interface';
import { Params } from '../interface/core.interface';

@Injectable({
  providedIn: 'root',
})
export class BlogService {
  public skeletonLoader: boolean = false;

  private http = inject(HttpClient);

  getBlogs(payload?: Params): Observable<IBlogModel> {
    return this.http.get<IBlogModel>(`${environment.URL}/blog`, { params: payload });
  }

  getBlogBySlug(slug: string): Observable<IBlog> {
    return this.http.get<IBlog>(`${environment.URL}/blog/slug/${slug}`);
  }
}
