import { HttpClient } from '@angular/common/http';
import { inject, Injectable } from '@angular/core';

import { Observable } from 'rxjs';

import { environment } from '../../../environments/environment';
import { IBrand, IBrandModel } from '../interface/brand.interface';
import { Params } from '../interface/core.interface';

@Injectable({
  providedIn: 'root',
})
export class BrandService {
  private http = inject(HttpClient);

  getBrands(payload?: Params): Observable<IBrandModel> {
    return this.http.get<IBrandModel>(`${environment.URL}/brand`, { params: payload });
  }

  getBrandBySlug(slug: string): Observable<IBrand> {
    return this.http.get<IBrand>(`${environment.URL}/brand/slug/${slug}`);
  }
}
