import { HttpClient } from '@angular/common/http';
import { inject, Injectable } from '@angular/core';

import { Observable } from 'rxjs';

import { environment } from '../../../environments/environment';
import { ICategory, ICategoryModel } from '../interface/category.interface';
import { Params } from '../interface/core.interface';

@Injectable({
  providedIn: 'root',
})
export class CategoryService {
  public searchSkeleton: boolean = false;

  private http = inject(HttpClient);

  getCategories(payload?: Params): Observable<ICategoryModel> {
    return this.http.get<ICategoryModel>(`${environment.URL}/category`, { params: payload });
  }

  getCategoryBySlug(slug: string): Observable<ICategory> {
    return this.http.get<ICategory>(`${environment.URL}/category/slug/${slug}`);
  }
}
