import { HttpClient } from '@angular/common/http';
import { inject, Injectable } from '@angular/core';
import { Params } from '@angular/router';

import { Observable } from 'rxjs';

import { environment } from '../../../environments/environment';
import { ICompareModel } from '../interface/compare.interface';

@Injectable({
  providedIn: 'root',
})
export class CompareService {
  public skeletonLoader: boolean = false;

  private http = inject(HttpClient);

  getComparItems(): Observable<ICompareModel> {
    return this.http.get<ICompareModel>(`${environment.URL}/compare`);
  }

  addCompar(payload: Params): Observable<ICompareModel> {
    return this.http.post<ICompareModel>(`${environment.URL}/compare`, payload);
  }

  deleteCompar(id: number): Observable<number> {
    return this.http.delete<number>(`${environment.URL}/compare/${id}`);
  }
}
