import { HttpClient } from '@angular/common/http';
import { inject, Injectable } from '@angular/core';
import { Params } from '@angular/router';

import { Observable } from 'rxjs';

import { environment } from '../../../environments/environment';
import { ICouponModel } from '../interface/coupon.interface';

@Injectable({
  providedIn: 'root',
})
export class CouponService {
  public skeletonLoader: boolean = false;

  private http = inject(HttpClient);

  getCoupons(payload?: Params): Observable<ICouponModel> {
    return this.http.get<ICouponModel>(`${environment.URL}/coupon`, { params: payload });
  }
}
