import { HttpClient } from '@angular/common/http';
import { inject, Injectable } from '@angular/core';
import { Params } from '@angular/router';

import { Observable } from 'rxjs';

import { environment } from '../../../environments/environment';
import { IDownloadModel } from '../interface/download.interface';

@Injectable({
  providedIn: 'root',
})
export class DownloadService {
  private http = inject(HttpClient);

  downloads(payload?: Params): Observable<IDownloadModel> {
    return this.http.get<IDownloadModel>(`${environment.URL}/download`, { params: payload });
  }

  downloadFiles(id: number): Observable<{ download_link: string }> {
    return this.http.post<{ download_link: string }>(`${environment.URL}/download/zip/link`, {
      id: id,
    });
  }

  downloadLicense(id: number): Observable<{ download_link: string }> {
    return this.http.post<{ download_link: string }>(`${environment.URL}/download/key/link`, {
      id: id,
    });
  }
}
