import { HttpClient } from '@angular/common/http';
import { inject, Injectable } from '@angular/core';

import { Observable } from 'rxjs';

import { environment } from '../../../environments/environment';
import { Params } from '../interface/core.interface';
import { ILanguageModel } from '../interface/language.interface';

@Injectable({
  providedIn: 'root',
})
export class LanguageService {
  private http = inject(HttpClient);

  getLanguage(payload?: Params): Observable<ILanguageModel> {
    return this.http.get<ILanguageModel>(`${environment.URL}/language`, { params: payload });
  }
}
