import { HttpClient } from '@angular/common/http';
import { inject, Injectable } from '@angular/core';
import { Params } from '@angular/router';

import { Observable } from 'rxjs';

import { environment } from '../../../environments/environment';
import { IMenuModel } from '../interface/menu.interface';

@Injectable({
  providedIn: 'root',
})
export class MenuService {
  public skeletonLoader: boolean = false;

  private http = inject(HttpClient);

  getMenu(payload?: Params): Observable<IMenuModel> {
    return this.http.get<IMenuModel>(`${environment.URL}/menu`, { params: payload });
  }
}
