import { HttpClient, HttpHeaders } from '@angular/common/http';
import { inject, Injectable } from '@angular/core';

import { Store } from '@ngxs/store';
import { Observable } from 'rxjs';

import { NotificationService } from './notification.service';
import { IValues } from '../interface/setting.interface';
import { SettingState } from '../state/setting.state';

@Injectable({
  providedIn: 'root',
})
export class NewsletterService {
  private http = inject(HttpClient);
  private notificationService = inject(NotificationService);

  setting$: Observable<IValues> = inject(Store).select(SettingState.setting) as Observable<IValues>;

  private listId: string;
  private apiKey: string;

  subscribe(email: string) {
    this.setting$.subscribe(setting => {
      this.listId = setting?.newsletter?.mailchip_list_id;
      this.apiKey = setting?.newsletter?.mailchip_api_key;
    });

    let headers = new HttpHeaders();
    headers = headers.append('Content-Type', 'application/json');
    headers = headers.append('Authorization', `Bearer ` + this.apiKey);
    headers = headers.append('Access-Control-Allow-Origin', '*');

    const url = `https://us21.api.mailchimp.com/3.0/lists/${this.listId}/members`;

    const body = JSON.stringify({
      email_address: email,
      status: 'subscribed',
    });

    return this.http.post(url, body, { headers: headers }).subscribe({
      next: _res => {
        this.notificationService.showSuccess('Subscribed Successfully');
      },
      error: error => {
        return error;
      },
    });
  }
}
