import { HttpClient } from '@angular/common/http';
import { inject, Injectable } from '@angular/core';

import { Observable } from 'rxjs';

import { environment } from '../../../environments/environment';
import { Params } from '../interface/core.interface';
import { IContactUsModel, IFaqModel, IPage, IPageModel } from '../interface/page.interface';
import { IStoresModel } from '../interface/store.interface';

@Injectable({
  providedIn: 'root',
})
export class PageService {
  public skeletonLoader: boolean = false;

  private http = inject(HttpClient);

  getPages(payload?: Params): Observable<IPageModel> {
    return this.http.get<IPageModel>(`${environment.URL}/page`, { params: payload });
  }

  getPageBySlug(slug: string): Observable<IPage> {
    return this.http.get<IPage>(`${environment.URL}/page/slug/${slug}`);
  }

  getFaqs(): Observable<IFaqModel> {
    return this.http.get<IFaqModel>(`${environment.URL}/faq`);
  }

  contactUs(payload: IContactUsModel) {
    return this.http.post(`${environment.URL}/contact-us`, payload);
  }

  getStores(payload?: Params): Observable<IStoresModel> {
    return this.http.get<IStoresModel>(`${environment.URL}/store`, { params: payload });
  }
}
