import { HttpClient } from '@angular/common/http';
import { inject, Injectable } from '@angular/core';

import { Store } from '@ngxs/store';
import { Observable } from 'rxjs';

import { environment } from '../../../environments/environment';
import { Params } from '../interface/core.interface';
import { IProduct, IProductModel } from '../interface/product.interface';

@Injectable({
  providedIn: 'root',
})
export class ProductService {
  private http = inject(HttpClient);
  private store = inject(Store);

  public skeletonLoader: boolean = false;
  public searchSkeleton: boolean = false;

  getProducts(payload?: Params): Observable<IProductModel> {
    const is_zone = this.store.selectSnapshot(
      state => state?.setting?.setting?.activation?.zone_enable,
    );
    const zone = this.store.selectSnapshot(state => state.zone.selectedZone);
    const params = {
      ...payload,
      ...(is_zone && { zone_ids: zone.join() }), // Include zone_ids only if is_zone is true
    };
    return this.http.get<IProductModel>(`${environment.URL}/product`, { params: params });
  }

  getProductBySlug(slug: string): Observable<IProduct> {
    return this.http.get<IProduct>(`${environment.URL}/product/slug/${slug}`);
  }

  getProductBySearch(payload?: Params): Observable<any> {
    return this.http.get<any>(`${environment.URL}/product/minify/list`, { params: payload });
  }
}
