import { HttpClient } from '@angular/common/http';
import { inject, Injectable } from '@angular/core';

import { Observable } from 'rxjs';

import { environment } from '../../../environments/environment';
import { IPublication } from '../interface/publication.interface';

@Injectable({
  providedIn: 'root',
})
export class PublicationService {
  private http = inject(HttpClient);

  getPublicationBySlug(slug: string): Observable<IPublication> {
    return this.http.get<IPublication>(`${environment.URL}/publication/slug/${slug}`);
  }
}
