import { HttpClient } from '@angular/common/http';
import { inject, Injectable } from '@angular/core';

import { Observable } from 'rxjs';

import { environment } from '../../../environments/environment';
import { Params } from '../interface/core.interface';
import { IQnAModel, IQuestionAnswers } from '../interface/questions-answers.interface';

@Injectable({
  providedIn: 'root',
})
export class QuestionsAnswersService {
  public skeletonLoader: boolean = false;

  private http = inject(HttpClient);

  getQuestionAnswers(slug: Params): Observable<IQnAModel> {
    return this.http.get<IQnAModel>(`${environment.URL}/question-and-answer`, { params: slug });
  }

  sendQuestion(payload: Params): Observable<IQuestionAnswers> {
    return this.http.post<IQuestionAnswers>(`${environment.URL}/question-and-answer`, payload);
  }

  updateQuestionAnswers(id: number, payload: Params): Observable<IQuestionAnswers> {
    return this.http.put<IQuestionAnswers>(`${environment.URL}/question-and-answer/${id}`, payload);
  }

  feedback(payload: Params): Observable<IQuestionAnswers> {
    return this.http.post<IQuestionAnswers>(
      `${environment.URL}/question-and-answer/feedback`,
      payload,
    );
  }
}
