import { HttpClient } from '@angular/common/http';
import { inject, Injectable } from '@angular/core';
import { Params } from '@angular/router';

import { Observable } from 'rxjs';

import { environment } from '../../../environments/environment';
import { IReview, IReviewModel } from '../interface/review.interface';

@Injectable({
  providedIn: 'root',
})
export class ReviewService {
  private http = inject(HttpClient);

  getReview(slug: Params): Observable<IReviewModel> {
    return this.http.get<IReviewModel>(`${environment.URL}/front/review`, { params: slug });
  }

  sendReview(payload: Params): Observable<IReview> {
    return this.http.post<IReview>(`${environment.URL}/review`, payload);
  }

  updateReview(id: number, payload: Params): Observable<IReview> {
    return this.http.put<IReview>(`${environment.URL}/review/${id}`, payload);
  }
}
