import { HttpClient } from '@angular/common/http';
import { inject, Injectable } from '@angular/core';

import { Observable } from 'rxjs';

import { environment } from '../../../environments/environment';
import { IGoogleReCaptcha, ISetting } from '../interface/setting.interface';

@Injectable({
  providedIn: 'root',
})
export class SettingService {
  reCaptchaConfig: IGoogleReCaptcha;

  private http = inject(HttpClient);

  getSettingOption(): Observable<ISetting> {
    return this.http.get<ISetting>(`${environment.URL}/settings`);
  }

  async getReCaptchaConfig(): Promise<void> {
    const config = await this.getSettingOption().toPromise();
    this.reCaptchaConfig = config?.values?.google_reCaptcha!;
  }
}
