import { HttpClient } from '@angular/common/http';
import { inject, Injectable } from '@angular/core';

import { Observable } from 'rxjs';

import { environment } from '../../../environments/environment';
import { Params } from '../interface/core.interface';
import { IStores, IStoresModel } from '../interface/store.interface';

@Injectable({
  providedIn: 'root',
})
export class StoreService {
  public skeletonLoader: boolean = false;

  private http = inject(HttpClient);

  getStores(payload?: Params): Observable<IStoresModel> {
    return this.http.get<IStoresModel>(`${environment.URL}/store`, { params: payload });
  }

  getStoreBySlug(slug: string): Observable<IStores> {
    return this.http.get<IStores>(`${environment.URL}/store/slug/${slug}`);
  }
}
