import { HttpClient } from '@angular/common/http';
import { inject, Injectable } from '@angular/core';

import { environment } from '../../../environments/environment';

export interface SubscriptionAction {
  email: string;
}

@Injectable({
  providedIn: 'root',
})
export class SubscriptionService {
  private http = inject(HttpClient);

  sendEmail(payload: SubscriptionAction) {
    return this.http.post(`${environment.URL}/subscribe`, payload);
  }
}
