import { HttpClient } from '@angular/common/http';
import { inject, Injectable } from '@angular/core';

import { Observable } from 'rxjs';

import { environment } from '../../../environments/environment';
import { IThemeOption } from '../interface/theme-option.interface';

@Injectable({
  providedIn: 'root',
})
export class ThemeOptionService {
  public preloader: boolean = true;
  public theme_color: string;
  public secondary_color: string;
  public previousRoute: string;
  public productBox: string = '';
  public isDigitalProductBox = false;

  private http = inject(HttpClient);

  getThemeOption(): Observable<IThemeOption> {
    return this.http.get<IThemeOption>(`${environment.URL}/themeOptions`);
  }
}
