import { HttpClient } from '@angular/common/http';
import { inject, Injectable } from '@angular/core';

import { Observable } from 'rxjs';

import { environment } from '../../../environments/environment';
import { Params } from '../interface/core.interface';
import { IWishlistModel } from '../interface/wishlist.interface';

@Injectable({
  providedIn: 'root',
})
export class WishlistService {
  public skeletonLoader: boolean = false;

  private http = inject(HttpClient);

  getWishlistItems(): Observable<IWishlistModel> {
    return this.http.get<IWishlistModel>(`${environment.URL}/wishlist`);
  }

  addToWishlist(payload: Params): Observable<IWishlistModel> {
    return this.http.post<IWishlistModel>(`${environment.URL}/wishlist`, payload);
  }

  deleteWishlist(id: number): Observable<number> {
    return this.http.delete<number>(`${environment.URL}/wishlist/${id}`);
  }
}
